//+------------------------------------------------------------------+
//|                                                                  |
//|                            Copyright  2006 ADX MA - idea by SID |
//|                                         cloned by DarkMan        |
//|                                  special thanks to Volf for help |
//+------------------------------------------------------------------+
#property  copyright "DarkMan CZFxTEAM"


//---- indicator settings
#property  indicator_chart_window
#property  indicator_buffers 3
#property indicator_color1 Yellow      
#property indicator_color2 Green
#property indicator_color3 Red

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];

extern int MA_perioda = 5;
extern int MA_typ = 1;
/*
0 Simple moving average, 
1 Exponential moving average, 
2 ADX_periodaed moving average, 
3 Linear weighted moving average. 
*/
extern int Cena = 0;
/*
0 Close price. 
1 Open price. 
2 High price. 
3 Low price. 
4 Median price, (high+low)/2. 
5 Typical price, (high+low+close)/3. 
6 Weighted close price, (high+low+close+close)/4. 
*/
extern int ADX_perioda = 14;

double wt[];
double MyConst[];
double ADXs[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- 2 additional buffers are used for counting.
   IndicatorBuffers(6);
   
//---- drawing settings
   SetIndexBuffer(2,ExtMapBuffer1);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexBuffer(0,ExtMapBuffer3);   
   SetIndexBuffer(3,wt);
   SetIndexBuffer(4,MyConst);
   SetIndexBuffer(5,ADXs);

   
      
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,2);
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,2);
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,2);

//---- initialization done
   return(0);
  }

int start(){   
      int i,x,a,counted_bars=IndicatorCounted();
     
      double EmaIndex = 0;
      if(MA_perioda>0){ 
         EmaIndex = (2.0/(1+MA_perioda));
      }else{
         EmaIndex = 0.20;
      }
      
      //Toz naplnim pole vyhlazenym ADX
      CalculateADX();
      
      double HADX,LADX,DIFF;      
 
      i=Bars-counted_bars-1;
      for(int shift = i; shift >= 0; shift--){    
         double vysledek=0;                     
        
         double adxtemp[];
         a = 0;         
         for (x=shift;x<=shift+ADX_perioda;x++){
            ArrayResize(adxtemp,a+1);
            adxtemp[a] = GetADX(x);
            a++;
         }    
         LADX = adxtemp[ArrayMinimum(adxtemp)];
         HADX = adxtemp[ArrayMaximum(adxtemp)];                           
                      
         DIFF = HADX - LADX;
         if (DIFF > 0){
            MyConst[shift] = (GetADX(shift)- LADX)/DIFF;
         }else{
            MyConst[shift] = EmaIndex;
         }
         if (MyConst[shift]>EmaIndex){
            MyConst[shift] = EmaIndex;
         }               
          if(Bars-shift < ADX_perioda+(ADX_perioda*1.5)) {            
            vysledek = Close[shift];   
          }else{   
            double emapole[4];
            ArraySetAsSeries(emapole,true);      
            emapole[0] = ( ((1 - MyConst[shift]  ) * wt[shift+1]) + (MyConst[shift]   * Close[shift]));
            emapole[1] = ( ((1 - MyConst[shift+1]) * wt[shift+2]) + (MyConst[shift+1] * Close[shift+1]));
            emapole[2] = ( ((1 - MyConst[shift+2]) * wt[shift+3]) + (MyConst[shift+2] * Close[shift+2]));
            emapole[3] = ( ((1 - MyConst[shift+3]) * wt[shift+4]) + (MyConst[shift+3] * Close[shift+3]));
            
            vysledek = iMAOnArray(emapole,0,2,0,MA_typ,0);
                                                                                         
          }         
                
         wt[shift] = vysledek;   
         
         ExtMapBuffer3[shift] =  wt[shift]; //red 
         ExtMapBuffer2[shift] =  wt[shift]; //green
         ExtMapBuffer1[shift] =  wt[shift]; //yellow
      
         if (GetPrice(shift) < wt[shift]){
            ExtMapBuffer2[shift+1] = EMPTY_VALUE;      
         }
         else if (GetPrice(shift) > wt[shift]){
             ExtMapBuffer1[shift+1] = EMPTY_VALUE; //-1 red/greem tight                    
         }else{
            ExtMapBuffer1[shift+1]=CLR_NONE;//EMPTY_VALUE;
            ExtMapBuffer2[shift+1]=CLR_NONE;//EMPTY_VALUE;
         }
        
      }
    
      return(0);
  }
//+------------------------------------------------------------------+
double GetPrice(int shift){
/*
0 Close price. 
1 Open price. 
2 High price. 
3 Low price. 
4 Median price, (high+low)/2. 
5 Typical price, (high+low+close)/3. 
6 Weighted close price, (high+low+close+close)/4. 
*/
   switch(Cena){
      case 0:
         return(Close[shift]);
      case 1:
         return(Open[shift]);
      case 2:
         return(High[shift]);
      case 3:
         return(Low[shift]);
      case 4:
         return((High[shift]+Low[shift])/2);
      case 5:
         return((High[shift]+Low[shift]+Close[shift])/3);      
      case 6:
         return((High[shift]+Low[shift]+Close[shift]+Close[shift])/4);      
    }
}
double GetADX(int shift){
   return(ADXs[shift]);
}
void CalculateADX(){ 
   double pdm,mdm,tr,xx,yy,ss,mm;
   double price_high,price_low;
   double sabit,toplam,MA,PREP,PREN,PRETR;
   double PD;
   double ND,Buff;
   double ADX,PREADX;
   int    starti,i,j,n;
   int DMIPeriod = ADX_perioda;
   int Smooth = ADX_perioda;

   if(Bars<=DMIPeriod) return(0);
   
   for(i=0;i<=Bars-2;i++){
      ADXs[i]=0.0;
   }
  
   PREP=0.0;
   PREN=0.0; 
   PRETR=0.0;
   ADX=0.0;
   PREADX=0.0;
   i=Bars-2;

   while(i>=0){   
      if(High[i]>High[i+1] && (High[i]-High[i+1])>(Low[i+1]-Low[i])){      
         xx=High[i]-High[i+1];
      }else{
         xx=0.0;      
      }
      
      PD=(((DMIPeriod-1.0)*PREP)+xx)/(DMIPeriod);
      
      if(Low[i]<Low[i+1] && (Low[i+1]-Low[i])>(High[i]-High[i+1])){
         xx=Low[i+1]-Low[i];
      }else{
         xx=0.0;
      }
      
      ND=(((DMIPeriod-1.0)*PREN)+xx)/(DMIPeriod);
      
      Buff = MathAbs(PD-ND);
      if (Buff == 0) {
         ADX=(((Smooth-1.0)*PREADX))/Smooth;  
      }else{   
         ADX=(((Smooth-1.0)*PREADX)+  (MathAbs(PD-ND)/(PD+ND)))/Smooth;
      }
            
      PREN=ND;       
      PREP=PD;
      PREADX=ADX;

      ADXs[i]=100*ADX;
      
      i--;
   }
}


